local assets =
{
	Asset("ANIM", "anim/sandhill.zip"),
	Asset("ATLAS", "images/inventoryimages/sand.xml"),
}
local function OnIgniteFn(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_fuse_LP", "hiss")
    DefaultBurnFn(inst)
end
local function OnExtinguishFn(inst)
    
    inst.SoundEmitter:KillSound("hiss")
    DefaultExtinguishFn(inst)
	
end
local function OnExplodeFn(inst)
    inst.SoundEmitter:KillSound("hiss")
    SpawnPrefab("explode_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	local x, y, z = inst.Transform:GetWorldPosition()
	local glass = SpawnPrefab("glass",2)
    glass.Transform:SetPosition(x, y, z)
end
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("sandhill")
    inst.AnimState:SetBuild("sandhill")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "sand"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/sand.xml"
    inst:AddComponent("selfstacker")
	
	
	MakeMediumBurnable(inst, nil, nil)
	MakeLargePropagator(inst)
	 inst.components.burnable:SetOnBurntFn(nil)
    inst.components.burnable:SetOnIgniteFn(OnIgniteFn)
    inst.components.burnable:SetOnExtinguishFn(OnExtinguishFn)
	inst:AddComponent("explosive")
    inst.components.explosive:SetOnExplodeFn(OnExplodeFn)
    inst.components.explosive.explosivedamage = 1
    inst.components.explosive.buildingdamage = 1
    inst.components.explosive.lightonexplode = false
    MakeHauntableLaunchAndSmash(inst)
    return inst
end

return Prefab("sand", fn, assets)